	function sig = hdlsignal(name, class, varargin)
	%sig = hdlsignal(name, class, ...)
	%
	%Creates a hdlsignal structure.
	%Arguments:
	%  name - name of signal
	%  class - signal class
	%  options - class-dependent options
	%
	%Signal classes [options]:
	%  0 - bit []
	%  1 - bit vector, options:
	%        width: integer width
	%        ref[, mod]: integer reference ref modified by mod
	%  2 - int [lowerbound upperbound]
	%  256 - time
	%  257 - string
	
	%Copyright 2010 Anton Blad
	
	%This file is part of vhdlgen.
	
	%vhdlgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	
	%vhdlgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	
	%You should have received a copy of the GNU General Public License
	%along with vhdlgen.  If not, see <http://www.gnu.org/licenses/>.
	
	sig.name = name;
	sig.type.class = class;
	
	switch class
	case 0,
		if nargin ~= 2
			error('hdlsignal: invalid number of arguments');
		end
	case 1,
		switch nargin
		case 3,
			if isnumeric(varargin{1})
				sig.type.width.class = 0;
				sig.type.width.val = varargin{1};
			else
				sig.type.width.class = 1;
				sig.type.width.ref = varargin{1};
			end
		case 4,
			sig.type.width.class = 1;
			sig.type.width.ref = varargin{1};
			sig.type.width.mod = varargin{2};
		otherwise,
			error('hdlsignal: invalid number of arguments');
		end
	case 2,
		if nargin == 3 | nargin > 4
			error('hdlsignal: invalid number of arguments');
		end
		if nargin == 4
			sig.type.range = [varargin{3} varargin{4}];
		end
	case 256,
		if nargin ~= 2
			error('hdlsignal: invalid number of arguments');
		end
	case 257,
		if nargin ~= 2
			error('hdlsignal: invalid number of arguments');
		end
	otherwise,
		error('hdlsignal: class %d not implemented', class);
	end
	
